{**********************************************************************
{*
{* Darts uMenu -- Version 3.0  (implementation)
{*
{* Copyright (c)
{* Apple Computer, Inc.  1986-1989
{* All Rights Reserved.
{*
{* Developer Technical Support Apple II Sample Code
{*
{* This file contains the code which implements 
{* menus in the program.
{*
{**********************************************************************}
{$R-}


{**********************************************************************************}
{*
{* doAboutItem
{*
{* Calls AlertWindow to display the about box.  The result is ignored.
{*
{**********************************************************************************}
procedure doAboutItem;

   begin   {of DoAboutItem}
        if 0 = AlertWindow(RefIsResource*2,NIL,Ptr(1)) then {do nothing};
   end;    {of DoAboutItem}


{**********************************************************************************}
{*
{* doNewItem
{*
{* Inits the current window for a new game.  Can be called in response to a 
{* menu selection or button press.
{*
{**********************************************************************************}
procedure doNewItem;
    var
        k : integer;
        j : integer;
        aLong : LongInt;
    begin
        score[Player1] := 0;
        score[Player2] := 0;
        
        invalScore(Player1);
        invalScore(Player2);
        
        clearList(Player1);
        clearList(Player2);
        
        for k := 1 to NumPlayers do
            for J := 15 to 25 do 
                CrickettTables[k][J] := 0;
        
        if gameType = 1 then
            begin
                k := 25;
                while k >= 15 do
                    begin
                        fixButtonTitle(Player1,k);
                        fixButtonTitle(Player2,k);
                        if k = 25 then k := 21;
                        k := k - 1;
                    end;
            end;
            
        weHaveAWinner := false;
    end;
    
    
{**********************************************************************************}
{*
{* doQuitItem
{*
{* Sets the global done flag to true in response to the quit menu time.  Can 
{* also be called in reponse to the quit button.
{*
{**********************************************************************************}
procedure doQuitItem;

   begin   {of DoQuitItem}
       quitFlag := true;
   end;    {of DoQuitItem}


{**********************************************************************************}
{*
{* doSwitchGames
{*
{* Switches from Robin to Crickett and back again.  This is called in response
{* to selections in the Game menu.  Note:  that if the selected item is
{* the current game, then nothing happens.
{*
{**********************************************************************************}
procedure doSwitchGames     (itemNum : integer);
    begin
        if ItemNum = RobinGameItem then ItemNum := 0
        else ItemNum := 1;
        
        if gameType <> itemNum then
            begin
                CloseWindow(theWindow);
                if itemNum = 0 then startupRobinGame
                else startupCrickettGame;
                gameType := itemNum;
                doNewItem;
            end;
    end;
    
    
{**********************************************************************************}
{*
{* doMenu
{*
{* This resonds to menu selections.  It is called by main event loop in 
{* response to all menu selctions (mouse and keyboard).
{*
{**********************************************************************************}
procedure doMenu;

   var menuNum : integer;
       itemNum : integer;

   begin   {of DoMenu}

       menuNum := HiWord (event.wmTaskData);
       itemNum := LoWord (event.wmTaskData);
   
       case itemNum of
           AboutItem    :  doAboutItem;
           NewItem      :  doNewItem;
           QuitItem     :  doQuitItem;
           UndoItem     :  ;
           CutItem      :  ;
           CopyItem     :  ;
           PasteItem    :  ;
           ClearItem    :  ;
           RobinGameItem,CrickettGameItem : doSwitchGames(itemNum);
       otherwise
           ;
       end;

       HiliteMenu (false,menuNum);     {Unhighlight the menu title}

   end;    {of DoMenu}



{**********************************************************************************}
{*
{* setUpMenus
{*
{* Creates the system menu bar with desk accessories.
{*
{**********************************************************************************}
procedure setUpMenus;

   var 
        height : integer;

   begin   {of SetUpMenus}
        SetSysBar(NewMenubar2(RefIsResource,ref(1),NIL));
        SetMenuBar(NIL);

        FixAppleMenu (AppleMenuID);               {Add DAs to apple menu    }
        height := FixMenuBar;                     {Set sizes of menus       }
        DrawMenuBar;                              {...and draw the menu bar!}
   end;    {of SetUpMenus}
